/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.global;

import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.SonarPlugin;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.global.ExtensionMatcher;
import org.sonarsource.sonarlint.core.plugin.DefaultPluginRepository;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;

public class ExtensionInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionInstaller.class);
    private final DefaultPluginRepository pluginRepository;

    public ExtensionInstaller(DefaultPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public ExtensionInstaller install(ComponentContainer container, ExtensionMatcher matcher) {
        for (PluginInfo pluginInfo : this.pluginRepository.getPluginInfos()) {
            SonarPlugin plugin = this.pluginRepository.getPluginInstance(pluginInfo.getKey());
            for (Object extension : plugin.getExtensions()) {
                if (!ExtensionInstaller.blacklisted(extension)) {
                    ExtensionInstaller.doInstall(container, matcher, pluginInfo, extension);
                    continue;
                }
                LOG.debug("Extension {} was blacklisted as it is not used by SonarLint", (Object)ExtensionInstaller.className(extension));
            }
        }
        List<ExtensionProvider> providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object object = provider.provide();
            if (object instanceof Iterable) {
                for (Object extension : (Iterable)object) {
                    ExtensionInstaller.doInstall(container, matcher, null, extension);
                }
                continue;
            }
            ExtensionInstaller.doInstall(container, matcher, null, object);
        }
        return this;
    }

    private static boolean blacklisted(Object extension) {
        String className = ExtensionInstaller.className(extension);
        return className.contains("JaCoCo") || className.contains("Surefire") || className.contains("Coverage") || className.contains("COV") || className.contains("PhpUnit");
    }

    private static String className(Object extension) {
        return extension instanceof Class ? ((Class)extension).getName() : extension.getClass().getName();
    }

    private static void doInstall(ComponentContainer container, ExtensionMatcher matcher, @Nullable PluginInfo pluginInfo, Object extension) {
        if (matcher.accept(extension)) {
            container.addExtension(pluginInfo, extension);
        } else {
            container.declareExtension(pluginInfo, extension);
        }
    }
}

